/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.nio.FloatBuffer;
import slick.Vector3f;
import slick.Vector4f;

public class Matrix4f {
    private float m00;
    private float m01;
    private float m02;
    private float m03;
    private float m10;
    private float m11;
    private float m12;
    private float m13;
    private float m20;
    private float m21;
    private float m22;
    private float m23;
    private float m30;
    private float m31;
    private float m32;
    private float m33;
    byte PROPERTY_PERSPECTIVE = 1;
    byte PROPERTY_IDENTITY = (byte)4;
    byte PROPERTY_AFFINE = (byte)2;
    byte PROPERTY_TRANSLATION = (byte)8;
    byte PROPERTY_ORTHONORMAL = (byte)16;
    int properties = 0;

    public Matrix4f() {
        this.setIdentity();
    }

    public Matrix4f(Vector4f col1, Vector4f col2, Vector4f col3, Vector4f col4) {
        this.m00 = col1.x;
        this.m10 = col1.y;
        this.m20 = col1.z;
        this.m30 = col1.w;
        this.m01 = col2.x;
        this.m11 = col2.y;
        this.m21 = col2.z;
        this.m31 = col2.w;
        this.m02 = col3.x;
        this.m12 = col3.y;
        this.m22 = col3.z;
        this.m32 = col3.w;
        this.m03 = col4.x;
        this.m13 = col4.y;
        this.m23 = col4.z;
        this.m33 = col4.w;
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.m33 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
    }

    public Matrix4f add(Matrix4f other) {
        Matrix4f result = new Matrix4f();
        result.m00 = this.m00 + other.m00;
        result.m10 = this.m10 + other.m10;
        result.m20 = this.m20 + other.m20;
        result.m30 = this.m30 + other.m30;
        result.m01 = this.m01 + other.m01;
        result.m11 = this.m11 + other.m11;
        result.m21 = this.m21 + other.m21;
        result.m31 = this.m31 + other.m31;
        result.m02 = this.m02 + other.m02;
        result.m12 = this.m12 + other.m12;
        result.m22 = this.m22 + other.m22;
        result.m32 = this.m32 + other.m32;
        result.m03 = this.m03 + other.m03;
        result.m13 = this.m13 + other.m13;
        result.m23 = this.m23 + other.m23;
        result.m33 = this.m33 + other.m33;
        return result;
    }

    public Matrix4f negate() {
        return this.multiply(-1.0f);
    }

    public Matrix4f subtract(Matrix4f other) {
        return this.add(other.negate());
    }

    public Matrix4f multiply(float scalar) {
        Matrix4f result = new Matrix4f();
        result.m00 = this.m00 * scalar;
        result.m10 = this.m10 * scalar;
        result.m20 = this.m20 * scalar;
        result.m30 = this.m30 * scalar;
        result.m01 = this.m01 * scalar;
        result.m11 = this.m11 * scalar;
        result.m21 = this.m21 * scalar;
        result.m31 = this.m31 * scalar;
        result.m02 = this.m02 * scalar;
        result.m12 = this.m12 * scalar;
        result.m22 = this.m22 * scalar;
        result.m32 = this.m32 * scalar;
        result.m03 = this.m03 * scalar;
        result.m13 = this.m13 * scalar;
        result.m23 = this.m23 * scalar;
        result.m33 = this.m33 * scalar;
        return result;
    }

    public Vector4f multiply(Vector4f vector) {
        float x = this.m00 * vector.x + this.m01 * vector.y + this.m02 * vector.z + this.m03 * vector.w;
        float y = this.m10 * vector.x + this.m11 * vector.y + this.m12 * vector.z + this.m13 * vector.w;
        float z = this.m20 * vector.x + this.m21 * vector.y + this.m22 * vector.z + this.m23 * vector.w;
        float w = this.m30 * vector.x + this.m31 * vector.y + this.m32 * vector.z + this.m33 * vector.w;
        return new Vector4f(x, y, z, w);
    }

    public Matrix4f multiply(Matrix4f other) {
        Matrix4f result = new Matrix4f();
        result.m00 = this.m00 * other.m00 + this.m01 * other.m10 + this.m02 * other.m20 + this.m03 * other.m30;
        result.m10 = this.m10 * other.m00 + this.m11 * other.m10 + this.m12 * other.m20 + this.m13 * other.m30;
        result.m20 = this.m20 * other.m00 + this.m21 * other.m10 + this.m22 * other.m20 + this.m23 * other.m30;
        result.m30 = this.m30 * other.m00 + this.m31 * other.m10 + this.m32 * other.m20 + this.m33 * other.m30;
        result.m01 = this.m00 * other.m01 + this.m01 * other.m11 + this.m02 * other.m21 + this.m03 * other.m31;
        result.m11 = this.m10 * other.m01 + this.m11 * other.m11 + this.m12 * other.m21 + this.m13 * other.m31;
        result.m21 = this.m20 * other.m01 + this.m21 * other.m11 + this.m22 * other.m21 + this.m23 * other.m31;
        result.m31 = this.m30 * other.m01 + this.m31 * other.m11 + this.m32 * other.m21 + this.m33 * other.m31;
        result.m02 = this.m00 * other.m02 + this.m01 * other.m12 + this.m02 * other.m22 + this.m03 * other.m32;
        result.m12 = this.m10 * other.m02 + this.m11 * other.m12 + this.m12 * other.m22 + this.m13 * other.m32;
        result.m22 = this.m20 * other.m02 + this.m21 * other.m12 + this.m22 * other.m22 + this.m23 * other.m32;
        result.m32 = this.m30 * other.m02 + this.m31 * other.m12 + this.m32 * other.m22 + this.m33 * other.m32;
        result.m03 = this.m00 * other.m03 + this.m01 * other.m13 + this.m02 * other.m23 + this.m03 * other.m33;
        result.m13 = this.m10 * other.m03 + this.m11 * other.m13 + this.m12 * other.m23 + this.m13 * other.m33;
        result.m23 = this.m20 * other.m03 + this.m21 * other.m13 + this.m22 * other.m23 + this.m23 * other.m33;
        result.m33 = this.m30 * other.m03 + this.m31 * other.m13 + this.m32 * other.m23 + this.m33 * other.m33;
        return result;
    }

    public Matrix4f transpose() {
        Matrix4f result = new Matrix4f();
        result.m00 = this.m00;
        result.m10 = this.m01;
        result.m20 = this.m02;
        result.m30 = this.m03;
        result.m01 = this.m10;
        result.m11 = this.m11;
        result.m21 = this.m12;
        result.m31 = this.m13;
        result.m02 = this.m20;
        result.m12 = this.m21;
        result.m22 = this.m22;
        result.m32 = this.m23;
        result.m03 = this.m30;
        result.m13 = this.m31;
        result.m23 = this.m32;
        result.m33 = this.m33;
        return result;
    }

    public void toBuffer(FloatBuffer buffer) {
        buffer.put(this.m00).put(this.m10).put(this.m20).put(this.m30);
        buffer.put(this.m01).put(this.m11).put(this.m21).put(this.m31);
        buffer.put(this.m02).put(this.m12).put(this.m22).put(this.m32);
        buffer.put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        buffer.flip();
    }

    public static Matrix4f orthographic(float left, float right, float bottom, float top, float near, float far) {
        Matrix4f ortho = new Matrix4f();
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        ortho.m00 = 2.0f / (right - left);
        ortho.m11 = 2.0f / (top - bottom);
        ortho.m22 = -2.0f / (far - near);
        ortho.m03 = tx;
        ortho.m13 = ty;
        ortho.m23 = tz;
        return ortho;
    }

    public static Matrix4f frustum(float left, float right, float bottom, float top, float near, float far) {
        Matrix4f frustum = new Matrix4f();
        float a = (right + left) / (right - left);
        float b = (top + bottom) / (top - bottom);
        float c = -(far + near) / (far - near);
        float d = -(2.0f * far * near) / (far - near);
        frustum.m00 = 2.0f * near / (right - left);
        frustum.m11 = 2.0f * near / (top - bottom);
        frustum.m02 = a;
        frustum.m12 = b;
        frustum.m22 = c;
        frustum.m32 = -1.0f;
        frustum.m23 = d;
        frustum.m33 = 0.0f;
        return frustum;
    }

    public static Matrix4f perspective(float fovy, float aspect, float near, float far) {
        Matrix4f perspective = new Matrix4f();
        float f = (float)(1.0 / Math.tan(Math.toRadians(fovy) / 2.0));
        perspective.m00 = f / aspect;
        perspective.m11 = f;
        perspective.m22 = (far + near) / (near - far);
        perspective.m32 = -1.0f;
        perspective.m23 = 2.0f * far * near / (near - far);
        perspective.m33 = 0.0f;
        return perspective;
    }

    public Matrix4f translate(float x, float y, float z) {
        Matrix4f translation = new Matrix4f();
        translation.m03 = x;
        translation.m13 = y;
        translation.m23 = z;
        return translation;
    }

    public static Matrix4f rotate(float angle, float x, float y, float z) {
        Matrix4f rotation = new Matrix4f();
        float c = (float)Math.cos(Math.toRadians(angle));
        float s = (float)Math.sin(Math.toRadians(angle));
        Vector3f vec = new Vector3f(x, y, z);
        if (vec.length() != 1.0f) {
            vec = vec.normalize();
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        rotation.m00 = x * x * (1.0f - c) + c;
        rotation.m10 = y * x * (1.0f - c) + z * s;
        rotation.m20 = x * z * (1.0f - c) - y * s;
        rotation.m01 = x * y * (1.0f - c) - z * s;
        rotation.m11 = y * y * (1.0f - c) + c;
        rotation.m21 = y * z * (1.0f - c) + x * s;
        rotation.m02 = x * z * (1.0f - c) + y * s;
        rotation.m12 = y * z * (1.0f - c) - x * s;
        rotation.m22 = z * z * (1.0f - c) + c;
        return rotation;
    }

    public static Matrix4f scale(float x, float y, float z) {
        Matrix4f scaling = new Matrix4f();
        scaling.m00 = x;
        scaling.m11 = y;
        scaling.m22 = z;
        return scaling;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        this.put(this, buffer.position(), buffer);
        return buffer;
    }

    public void put(Matrix4f m, int offset, FloatBuffer dest) {
        if (offset == 0) {
            this.put0(m, dest);
        } else {
            this.putN(m, offset, dest);
        }
    }

    public void put0(Matrix4f m, FloatBuffer dest) {
        dest.put(0, m.m00()).put(1, m.m01()).put(2, m.m02()).put(3, m.m03()).put(4, m.m10()).put(5, m.m11()).put(6, m.m12()).put(7, m.m13()).put(8, m.m20()).put(9, m.m21()).put(10, m.m22()).put(11, m.m23()).put(12, m.m30()).put(13, m.m31()).put(14, m.m32()).put(15, m.m33());
    }

    public void putN(Matrix4f m, int offset, FloatBuffer dest) {
        dest.put(offset, m.m00()).put(offset + 1, m.m01()).put(offset + 2, m.m02()).put(offset + 3, m.m03()).put(offset + 4, m.m10()).put(offset + 5, m.m11()).put(offset + 6, m.m12()).put(offset + 7, m.m13()).put(offset + 8, m.m20()).put(offset + 9, m.m21()).put(offset + 10, m.m22()).put(offset + 11, m.m23()).put(offset + 12, m.m30()).put(offset + 13, m.m31()).put(offset + 14, m.m32()).put(offset + 15, m.m33());
    }

    public int properties() {
        return this.properties;
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m02() {
        return this.m02;
    }

    public float m03() {
        return this.m03;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m12() {
        return this.m12;
    }

    public float m13() {
        return this.m13;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    public float m22() {
        return this.m22;
    }

    public float m23() {
        return this.m23;
    }

    public float m30() {
        return this.m30;
    }

    public float m31() {
        return this.m31;
    }

    public float m32() {
        return this.m32;
    }

    public float m33() {
        return this.m33;
    }

    public void zero(Matrix4f dest) {
        dest._m00(0.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(0.0f);
    }

    Matrix4f _m00(float m00) {
        this.m00 = m00;
        return this;
    }

    Matrix4f _m01(float m01) {
        this.m01 = m01;
        return this;
    }

    Matrix4f _m02(float m02) {
        this.m02 = m02;
        return this;
    }

    Matrix4f _m03(float m03) {
        this.m03 = m03;
        return this;
    }

    Matrix4f _m10(float m10) {
        this.m10 = m10;
        return this;
    }

    Matrix4f _m11(float m11) {
        this.m11 = m11;
        return this;
    }

    Matrix4f _m12(float m12) {
        this.m12 = m12;
        return this;
    }

    Matrix4f _m13(float m13) {
        this.m13 = m13;
        return this;
    }

    Matrix4f _m20(float m20) {
        this.m20 = m20;
        return this;
    }

    Matrix4f _m21(float m21) {
        this.m21 = m21;
        return this;
    }

    Matrix4f _m22(float m22) {
        this.m22 = m22;
        return this;
    }

    Matrix4f _m23(float m23) {
        this.m23 = m23;
        return this;
    }

    Matrix4f _m30(float m30) {
        this.m30 = m30;
        return this;
    }

    Matrix4f _m31(float m31) {
        this.m31 = m31;
        return this;
    }

    Matrix4f _m32(float m32) {
        this.m32 = m32;
        return this;
    }

    Matrix4f _m33(float m33) {
        this.m33 = m33;
        return this;
    }

    Matrix4f _properties(int properties) {
        this.properties = properties;
        return this;
    }

    public Matrix4f identity() {
        if ((this.properties & this.PROPERTY_IDENTITY) != 0) {
            return this;
        }
        return this._m00(1.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f)._properties(this.PROPERTY_IDENTITY | this.PROPERTY_AFFINE | this.PROPERTY_TRANSLATION | this.PROPERTY_ORTHONORMAL);
    }

    public Matrix4f setPerspective(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        this.zero(this);
        float h = (float)Math.tan(fovy * 0.5f);
        this._m00(1.0f / (h * aspect))._m11(1.0f / h);
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            this._m22(e - 1.0f)._m32((e - (zZeroToOne ? 1.0f : 2.0f)) * zNear);
        } else if (nearInf) {
            float e = 1.0E-6f;
            this._m22((zZeroToOne ? 0.0f : 1.0f) - e)._m32(((zZeroToOne ? 1.0f : 2.0f) - e) * zFar);
        } else {
            this._m22((zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar))._m32((zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar));
        }
        return this._m23(-1.0f)._properties(this.PROPERTY_PERSPECTIVE);
    }

    public void identity(Matrix4f dest) {
        dest._m00(1.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f);
    }

    public Matrix4f rotateX(float ang) {
        return this.rotateX(ang, this);
    }

    public Matrix4f rotationX(float ang) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        if ((this.properties & this.PROPERTY_IDENTITY) == 0) {
            this.identity(this);
        }
        this._m11(cos)._m12(sin)._m21(-sin)._m22(cos)._properties(this.PROPERTY_AFFINE | this.PROPERTY_ORTHONORMAL);
        return this;
    }

    public Matrix4f setTranslation(float x, float y, float z) {
        return this._m30(x)._m31(y)._m32(z)._properties(this.properties & ~(this.PROPERTY_PERSPECTIVE | this.PROPERTY_IDENTITY));
    }

    public Matrix4f rotateX(float ang, Matrix4f dest) {
        if ((this.properties & this.PROPERTY_IDENTITY) != 0) {
            return dest.rotationX(ang);
        }
        if ((this.properties & this.PROPERTY_TRANSLATION) != 0) {
            float x = this.m30;
            float y = this.m31;
            float z = this.m32;
            return dest.rotationX(ang).setTranslation(x, y, z);
        }
        return this.rotateXInternal(ang, dest);
    }

    private Matrix4f rotateXInternal(float ang, Matrix4f dest) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        float lm10 = this.m10;
        float lm11 = this.m11;
        float lm12 = this.m12;
        float lm13 = this.m13;
        float lm20 = this.m20;
        float lm21 = this.m21;
        float lm22 = this.m22;
        float lm23 = this.m23;
        return dest._m20(lm10 * -sin + lm20 * cos)._m21(lm11 * -sin + lm21 * cos)._m22(lm12 * -sin + lm22 * cos)._m23(lm13 * -sin + lm23 * cos)._m10(lm10 * cos + lm20 * sin)._m11(lm11 * cos + lm21 * sin)._m12(lm12 * cos + lm22 * sin)._m13(lm13 * cos + lm23 * sin)._m00(this.m00)._m01(this.m01)._m02(this.m02)._m03(this.m03)._m30(this.m30)._m31(this.m31)._m32(this.m32)._m33(this.m33)._properties(this.properties & ~(this.PROPERTY_PERSPECTIVE | this.PROPERTY_IDENTITY | this.PROPERTY_TRANSLATION));
    }

    public Matrix4f rotateY(float ang) {
        return this.rotateY(ang, this);
    }

    public Matrix4f rotateY(float ang, Matrix4f dest) {
        if ((this.properties & this.PROPERTY_IDENTITY) != 0) {
            return dest.rotationY(ang);
        }
        if ((this.properties & this.PROPERTY_TRANSLATION) != 0) {
            float x = this.m30;
            float y = this.m31;
            float z = this.m32;
            return dest.rotationY(ang).setTranslation(x, y, z);
        }
        return this.rotateYInternal(ang, dest);
    }

    private Matrix4f rotateYInternal(float ang, Matrix4f dest) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        float nm00 = this.m00 * cos + this.m20 * -sin;
        float nm01 = this.m01 * cos + this.m21 * -sin;
        float nm02 = this.m02 * cos + this.m22 * -sin;
        float nm03 = this.m03 * cos + this.m23 * -sin;
        return dest._m20(this.m00 * sin + this.m20 * cos)._m21(this.m01 * sin + this.m21 * cos)._m22(this.m02 * sin + this.m22 * cos)._m23(this.m03 * sin + this.m23 * cos)._m00(nm00)._m01(nm01)._m02(nm02)._m03(nm03)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m13(this.m13)._m30(this.m30)._m31(this.m31)._m32(this.m32)._m33(this.m33)._properties(this.properties & ~(this.PROPERTY_PERSPECTIVE | this.PROPERTY_IDENTITY | this.PROPERTY_TRANSLATION));
    }

    public Matrix4f rotationY(float ang) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        if ((this.properties & this.PROPERTY_IDENTITY) == 0) {
            this.identity(this);
        }
        this._m00(cos)._m02(-sin)._m20(sin)._m22(cos)._properties(this.PROPERTY_AFFINE | this.PROPERTY_ORTHONORMAL);
        return this;
    }

    public Vector3f positiveZ(Vector3f dir) {
        return dir.set(this.m10 * this.m21 - this.m11 * this.m20, this.m20 * this.m01 - this.m21 * this.m00, this.m00 * this.m11 - this.m01 * this.m10).normalize();
    }

    public Vector3f positiveX(Vector3f dir) {
        return dir.set(this.m11 * this.m22 - this.m12 * this.m21, this.m02 * this.m21 - this.m01 * this.m22, this.m01 * this.m12 - this.m02 * this.m11).normalize();
    }
}

